const utils = require('myscripts_utils');
const validators = require('myscripts_validators');

const reggieDateTime = /^(\d{4}).(\d{2}).(\d{2}) (\d{2}):(\d{2}):(\d{2})$/;

exports.executeReceiptSize = function(task) {
    Fptr.setParam(Fptr.LIBFPTR_PARAM_FN_DATA_TYPE, Fptr.LIBFPTR_FNDT_FFD_VERSIONS);
    if (Fptr.fnQueryData() < 0) {
        return Fptr.error()
    }
    var ffd = Fptr.getParamInt(Fptr.LIBFPTR_PARAM_FFD_VERSION);

    if (!validators.isMissing(task.operator) && task.operator.name) {
        Fptr.setParam(1021, task.operator.name);
        Fptr.setParam(1203, task.operator.vatin, Fptr.IGNORE_IF_EMPTY);
        // Подаём параметр LIBFPTR_PARAM_MODE, чтобы провести метод operatorLogin виртуально
        Fptr.setParam(Fptr.LIBFPTR_PARAM_MODE, 1);
        if (Fptr.operatorLogin() < 0) {
            return Fptr.error();
        }
    }

    // Готовим данные клиента для передачи чек для ФФД 1.2
    var clientInfoSTLV = new Uint8Array([]);
    if (!validators.isMissing(task.clientInfo) && ffd >= Fptr.LIBFPTR_FFD_1_2) {
        Fptr.setParam(1227, task.clientInfo.name, Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(1228, task.clientInfo.vatin, Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(1243, task.clientInfo.birthDate, Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(1244, task.clientInfo.citizenship, Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(1245, task.clientInfo.identityDocumentCode, Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(1246, task.clientInfo.identityDocumentData, Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(1254, task.clientInfo.address, Fptr.IGNORE_IF_EMPTY);
        Fptr.utilFormTlv();
        clientInfoSTLV = Fptr.getParamByteArray(Fptr.LIBFPTR_PARAM_TAG_VALUE);
    }

    var operationInfoSTLV = new Uint8Array([]);
    if (!validators.isMissing(task.operationInfo) && ffd >= Fptr.LIBFPTR_FFD_1_2) {
        var dateTimeString = task.operationInfo.dateTime;
        var dateTimeArray = reggieDateTime.exec(dateTimeString);
        var dateTimeObject = new Date();
        dateTimeObject.setUTCFullYear(+dateTimeArray[1]);
        dateTimeObject.setUTCMonth(+dateTimeArray[2] - 1, +dateTimeArray[3]);
        dateTimeObject.setUTCHours(+dateTimeArray[4], +dateTimeArray[5], +dateTimeArray[6], 0);
        Fptr.setParam(1273, dateTimeObject, Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(1271, task.operationInfo.id, Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(1272, task.operationInfo.data, Fptr.IGNORE_IF_EMPTY);
        if (Fptr.utilFormTlv() < 0) {
            return Fptr.error();
        }
        operationInfoSTLV = Fptr.getParamByteArray(Fptr.LIBFPTR_PARAM_TAG_VALUE);
    }

    var arr1261 = new Array();
    var industryInfoSTLV = new Uint8Array([]);
    if (!validators.isMissing(task.industryInfo) && ffd >= Fptr.LIBFPTR_FFD_1_2) {
        for (var i = 0; i < task.industryInfo.length; i++) {
            Fptr.setParam(1262, task.industryInfo[i].fois, Fptr.IGNORE_IF_EMPTY);
            Fptr.setParam(1263, task.industryInfo[i].date, Fptr.IGNORE_IF_EMPTY);
            Fptr.setParam(1264, task.industryInfo[i].number, Fptr.IGNORE_IF_EMPTY);
            Fptr.setParam(1265, task.industryInfo[i].industryAttribute, Fptr.IGNORE_IF_EMPTY);
            if (Fptr.utilFormTlv() < 0) {
                return Fptr.error();
            }
            arr1261.push(Fptr.getParamByteArray(Fptr.LIBFPTR_PARAM_TAG_VALUE));
        }
    }

    Fptr.setParam(Fptr.LIBFPTR_PARAM_RECEIPT_TYPE, utils.RECEIPT_TYPES[task.type]);

    Fptr.setParam(Fptr.LIBFPTR_PARAM_USE_VAT18, task.useVAT18, Fptr.IGNORE_IF_EMPTY);
    Fptr.setParam(Fptr.LIBFPTR_PARAM_RECEIPT_ELECTRONICALLY, task.electronically, Fptr.IGNORE_IF_EMPTY);
    Fptr.setParam(Fptr.LIBFPTR_PARAM_MERGE_POSITIONS, task.mergePositions, Fptr.IGNORE_IF_EMPTY);
    Fptr.setParam(1055, utils.TAXATION_TYPES[task.taxationType], Fptr.IGNORE_IF_EMPTY);

    if (!validators.isMissing(task.clientInfo)) {
        Fptr.setParam(1008, task.clientInfo.emailOrPhone, Fptr.IGNORE_IF_EMPTY);

        if (ffd < Fptr.LIBFPTR_FFD_1_2) {
            Fptr.setParam(1227, task.clientInfo.name, Fptr.IGNORE_IF_EMPTY);
            Fptr.setParam(1228, task.clientInfo.vatin, Fptr.IGNORE_IF_EMPTY);
        } else {
            Fptr.setParam(1256, clientInfoSTLV, Fptr.IGNORE_IF_EMPTY);
        }
    }

    Fptr.setParam(1270, operationInfoSTLV, Fptr.IGNORE_IF_EMPTY);

    for (var i = 0; i < arr1261.length; i++) {
        Fptr.setParam(1261, arr1261[i], Fptr.IGNORE_IF_EMPTY);
    }

    if (!validators.isMissing(task.companyInfo)) {
        Fptr.setParam(1117, task.companyInfo.email, Fptr.IGNORE_IF_EMPTY);
    }
    Fptr.setParam(1009, task.paymentsAddress, Fptr.IGNORE_IF_EMPTY);
    Fptr.setParam(1187, task.paymentsPlace, Fptr.IGNORE_IF_EMPTY);
    Fptr.setParam(1036, task.machineNumber, Fptr.IGNORE_IF_EMPTY);

    if (!validators.isMissing(task.agentInfo)) {
        if (!validators.isMissing(task.agentInfo.agents) && ffd < Fptr.LIBFPTR_FFD_1_2) {
            var agentType = Fptr.LIBFPTR_AT_NONE;
            for (var i = 0; i < task.agentInfo.agents.length; i++) {
                agentType |= utils.AGENT_TYPES[task.agentInfo.agents[i]];
            }
            if (agentType > 0) {
                Fptr.setParam(1057, agentType);
            }
        }

        if (!validators.isMissing(task.agentInfo.moneyTransferOperator)) {
            Fptr.setParam(1005, task.agentInfo.moneyTransferOperator.address, Fptr.IGNORE_IF_EMPTY);
            Fptr.setParam(1016, task.agentInfo.moneyTransferOperator.vatin, Fptr.IGNORE_IF_EMPTY);
            Fptr.setParam(1026, task.agentInfo.moneyTransferOperator.name, Fptr.IGNORE_IF_EMPTY);
            phones = task.agentInfo.moneyTransferOperator.phones;
            for (var i = 0; phones && i < phones.length; i++) {
                Fptr.setParam(1075, phones[i], Fptr.IGNORE_IF_EMPTY);
            }
        }
        if (!validators.isMissing(task.agentInfo.payingAgent)) {
            Fptr.setParam(1044, task.agentInfo.payingAgent.operation, Fptr.IGNORE_IF_EMPTY);
            phones = task.agentInfo.payingAgent.phones;
            for (var i = 0; phones && i < phones.length; i++) {
                Fptr.setParam(1073, phones[i], Fptr.IGNORE_IF_EMPTY);
            }
        }
        if (!validators.isMissing(task.agentInfo.receivePaymentsOperator)) {
            phones = task.agentInfo.receivePaymentsOperator.phones;
            for (var i = 0; phones && i < phones.length; i++) {
                Fptr.setParam(1074, phones[i], Fptr.IGNORE_IF_EMPTY);
            }
        }
    }
    if (!validators.isMissing(task.supplierInfo)) {
        if (ffd >= Fptr.LIBFPTR_FFD_1_2) {
            if (validators.isMissing(task.supplierInfo.supplierVatinPrint) || task.supplierInfo.supplierVatinPrint) {
                Fptr.setParam(1226, task.supplierInfo.vatin, Fptr.IGNORE_IF_EMPTY);
            }
            else {
                Fptr.setNonPrintableParam(1226, task.supplierInfo.vatin, Fptr.IGNORE_IF_EMPTY);
            }
        }
        phones = task.supplierInfo.phones;
        for (var i = 0; phones && i < phones.length; i++) {
            Fptr.setParam(1171, phones[i], Fptr.IGNORE_IF_EMPTY);
        }
    }
    // Подаём параметр LIBFPTR_PARAM_MODE, чтобы провести метод openReceipt виртуально
    Fptr.setParam(Fptr.LIBFPTR_PARAM_MODE, 1);
    if (Fptr.openReceipt() < 0) {
        return Fptr.error();
    }

    // Размера чека даже при открытии не может быть равен 0, значит функция не доступна
    // Считаем, что из-за отсутствия лицензии 19
    if (Fptr.getParamInt(Fptr.LIBFPTR_PARAM_RECEIPT_SIZE) == 0)
        return Fptr.result(Fptr.LIBFPTR_ERROR_DENIED_BY_LICENSE, "Команда не разрешена введенными лицензиями ККТ, отсутствует лицензия 19")

    for (var l = 0; l < task.items.length; l++) {
        if (task.items[l].type !== "position") {
            continue;
        }
        var position = task.items[l];
        if (!validators.isMissing(position.agentInfo)) {
            if (!validators.isMissing(position.agentInfo.moneyTransferOperator)) {
                Fptr.setParam(1005, position.agentInfo.moneyTransferOperator.address, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1016, position.agentInfo.moneyTransferOperator.vatin, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1026, position.agentInfo.moneyTransferOperator.name, Fptr.IGNORE_IF_EMPTY);
                phones = position.agentInfo.moneyTransferOperator.phones;
                for (var i = 0; phones && i < phones.length; i++) {
                    Fptr.setParam(1075, phones[i], Fptr.IGNORE_IF_EMPTY);
                }
            }
            if (!validators.isMissing(position.agentInfo.payingAgent)) {
                Fptr.setParam(1044, position.agentInfo.payingAgent.operation, Fptr.IGNORE_IF_EMPTY);
                phones = position.agentInfo.payingAgent.phones;
                for (var i = 0; phones && i < phones.length; i++) {
                    Fptr.setParam(1073, phones[i], Fptr.IGNORE_IF_EMPTY);
                }
            }

            if (!validators.isMissing(position.agentInfo.receivePaymentsOperator)) {
                phones = position.agentInfo.receivePaymentsOperator.phones;
                for (var i = 0; phones && i < phones.length; i++) {
                    Fptr.setParam(1074, phones[i], Fptr.IGNORE_IF_EMPTY);
                }
            }

            Fptr.utilFormTlv();
            var tag1223 = Fptr.getParamByteArray(Fptr.LIBFPTR_PARAM_TAG_VALUE);
        }

        if (!validators.isMissing(position.supplierInfo)) {
            Fptr.setParam(1225, position.supplierInfo.name, Fptr.IGNORE_IF_EMPTY);
            phones = position.supplierInfo.phones;
            for (var i = 0; phones && i < phones.length; i++) {
                Fptr.setParam(1171, phones[i], Fptr.IGNORE_IF_EMPTY);
            }

            if (ffd >= Fptr.LIBFPTR_FFD_1_2) {

            }

            Fptr.utilFormTlv();
            var tag1224 = Fptr.getParamByteArray(Fptr.LIBFPTR_PARAM_TAG_VALUE);
        }

        var arr1260 = new Array();
        if (!validators.isMissing(position.industryInfo) && ffd >= Fptr.LIBFPTR_FFD_1_2) {
            for (var i = 0; i < position.industryInfo.length; i++) {
                Fptr.setParam(1262, position.industryInfo[i].fois, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1263, position.industryInfo[i].date, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1264, position.industryInfo[i].number, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1265, position.industryInfo[i].industryAttribute, Fptr.IGNORE_IF_EMPTY);
                if (Fptr.utilFormTlv() < 0) {
                    return Fptr.error();
                }
                arr1260.push(Fptr.getParamByteArray(Fptr.LIBFPTR_PARAM_TAG_VALUE));
            }
        }


        // Ниже подаются только параметры регистрации, вызовы других методов (utilFormTlv) запрещены

        if (!validators.isMissing(position.productCodes) && ffd >= Fptr.LIBFPTR_FFD_1_2) {
            var codesArray = validators.mustArrayOrMissing(position.productCodes.codes, "productCodes.codes");
            if (!validators.isMissing(codesArray)) {
                for (var i = 0; codesArray && (i < codesArray.length); i++) {
                    Fptr.setParam(Fptr.LIBFPTR_PARAM_PRODUCT_CODE, codesArray[i], Fptr.IGNORE_IF_EMPTY);
                }
            } else {
                Fptr.setParam(1300, position.productCodes.undefined, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1301, position.productCodes.ean8, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1302, position.productCodes.ean13, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1303, position.productCodes.itf14, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1304, position.productCodes.gs10, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1305, position.productCodes.gs1m, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1306, position.productCodes.short, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1307, position.productCodes.furs, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1308, position.productCodes.egais20, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1309, position.productCodes.egais30, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1320, position.productCodes.f1, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1321, position.productCodes.f2, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1322, position.productCodes.f3, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1323, position.productCodes.f4, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1324, position.productCodes.f5, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(1325, position.productCodes.f6, Fptr.IGNORE_IF_EMPTY);
            }
        }


        if (!validators.isMissing(position.markingCode)) {
            Fptr.setParam(Fptr.LIBFPTR_PARAM_MARKING_CODE, Duktape.dec("base64", position.markingCode.mark));
            Fptr.setParam(Fptr.LIBFPTR_PARAM_MARKING_CODE_TYPE, utils.MARKING_CODE_TYPES[position.markingCode.type], Fptr.IGNORE_IF_EMPTY);
        } else if (!validators.isMissing(position.imcParams)) {
            try {
                Fptr.setParam(Fptr.LIBFPTR_PARAM_MARKING_CODE, Duktape.dec("base64", position.imcParams.imc));
            } catch (e) {
                Fptr.setParam(Fptr.LIBFPTR_PARAM_MARKING_CODE, position.imcParams.imc);
            }

            if (!validators.isMissing(position.imcParams.imcType)) {
                Fptr.setParam(Fptr.LIBFPTR_PARAM_MARKING_CODE_TYPE, utils.MARKING_CODE_TYPES_1_2[position.imcParams.imcType], Fptr.IGNORE_IF_EMPTY);
            }
            if (!validators.isMissing(position.imcParams.itemFractionalAmount)) {
                Fptr.setParam(Fptr.LIBFPTR_PARAM_MARKING_FRACTIONAL_QUANTITY, position.imcParams.itemFractionalAmount);
            }
            if (!validators.isMissing(position.imcParams.itemEstimatedStatus)) {
                Fptr.setParam(Fptr.LIBFPTR_PARAM_MARKING_CODE_STATUS, utils.parseMarkingEstimatedStatus(position.imcParams.itemEstimatedStatus));
            }
            if (!validators.isMissing(position.imcParams.imcModeProcessing)) {
                Fptr.setParam(Fptr.LIBFPTR_PARAM_MARKING_PROCESSING_MODE, position.imcParams.imcModeProcessing);
            }
            if (!validators.isMissing(position.imcParams.imcBarcode)) {
                Fptr.setParam(Fptr.LIBFPTR_PARAM_MARKING_PRODUCT_ID, Duktape.dec("base64", position.imcParams.imcBarcode));
            }
            if (!validators.isMissing(position.imcParams.itemInfoCheckResult)) {
                var value = 0;
                if (position.imcParams.itemInfoCheckResult.imcCheckFlag)
                    value += (1 << 0);
                if (position.imcParams.itemInfoCheckResult.imcCheckResult)
                    value += (1 << 1);
                if (position.imcParams.itemInfoCheckResult.imcStatusInfo)
                    value += (1 << 2);
                if (position.imcParams.itemInfoCheckResult.imcEstimatedStatusCorrect)
                    value += (1 << 3);
                if (position.imcParams.itemInfoCheckResult.ecrStandAloneFlag)
                    value += (1 << 4);
                Fptr.setParam(Fptr.LIBFPTR_PARAM_MARKING_CODE_ONLINE_VALIDATION_RESULT, value);
            }
        } else if (!validators.isMissing(position.nomenclatureCode)) {
            if (typeof position.nomenclatureCode === "string") {
                Fptr.setParam(1162, Duktape.dec("base64", position.nomenclatureCode));
            } else if (typeof position.nomenclatureCode === "object" && !validators.isMissing(position.nomenclatureCode)) {
                switch (position.nomenclatureCode.type) {
                    case "furs":
                        Fptr.setParam(Fptr.LIBFPTR_PARAM_NOMENCLATURE_TYPE, Fptr.LIBFPTR_NT_FURS);
                        break;
                    case "medicines":
                        Fptr.setParam(Fptr.LIBFPTR_PARAM_NOMENCLATURE_TYPE, Fptr.LIBFPTR_NT_MEDICINES);
                        break;
                    case "tobacco":
                        Fptr.setParam(Fptr.LIBFPTR_PARAM_NOMENCLATURE_TYPE, Fptr.LIBFPTR_NT_TOBACCO);
                        break;
                    case "shoes":
                        Fptr.setParam(Fptr.LIBFPTR_PARAM_NOMENCLATURE_TYPE, Fptr.LIBFPTR_NT_SHOES);
                        break;
                }
                Fptr.setParam(Fptr.LIBFPTR_PARAM_GTIN, position.nomenclatureCode.gtin, Fptr.IGNORE_IF_EMPTY);
                Fptr.setParam(Fptr.LIBFPTR_PARAM_SERIAL_NUMBER, position.nomenclatureCode.serial);
                if (Fptr.utilFormNomenclature() < 0) {
                    return Fptr.error();
                }

                Fptr.setParam(1162, Fptr.getParamByteArray(Fptr.LIBFPTR_PARAM_TAG_VALUE));
            }
        }

        if (!validators.isMissing(position.agentInfo)) {
            if (!validators.isMissing(position.agentInfo.agents)) {
                var agentType = Fptr.LIBFPTR_AT_NONE;
                for (var i = 0; i < position.agentInfo.agents.length; i++) {
                    agentType |= utils.AGENT_TYPES[position.agentInfo.agents[i]];
                }
                if (agentType > 0) {
                    if (validators.isMissing(position.agentInfo.agentsPrint) || position.agentInfo.agentsPrint) {
                        Fptr.setParam(1222, agentType);
                    }
                    else {
                        Fptr.setNonPrintableParam(1222, agentType);
                    }
                }
            }
        }
        if (!validators.isMissing(position.supplierInfo)) {
            if (validators.isMissing(position.supplierInfo.supplierVatinPrint) || position.supplierInfo.supplierVatinPrint) {
                Fptr.setParam(1226, position.supplierInfo.vatin, Fptr.IGNORE_IF_EMPTY);
            }
            else {
                Fptr.setNonPrintableParam(1226, position.supplierInfo.vatin, Fptr.IGNORE_IF_EMPTY);
            }
        }

        if (!validators.isMissing(position.agentInfo)) {
            if (validators.isMissing(position.agentInfo.agentDataPrint) || position.agentInfo.agentDataPrint) {
                Fptr.setParam(1223, tag1223, Fptr.IGNORE_IF_EMPTY);
            } else {
                Fptr.setNonPrintableParam(1223, tag1223, Fptr.IGNORE_IF_EMPTY);
            }
        }
        if (!validators.isMissing(position.supplierInfo)) {
            if (validators.isMissing(position.supplierInfo.supplierPrint) || position.supplierInfo.supplierPrint) {
                Fptr.setParam(1224, tag1224, Fptr.IGNORE_IF_EMPTY);
            } else {
                Fptr.setNonPrintableParam(1224, tag1224, Fptr.IGNORE_IF_EMPTY);
            }
        }

        if (ffd >= Fptr.LIBFPTR_FFD_1_2) {
            if (!validators.isMissing(position.measurementUnit))
                Fptr.setParam(2108, utils.parseItemUnits(position.measurementUnit), Fptr.IGNORE_IF_EMPTY);
        } else {
            if (!validators.isMissing(position.measurementUnit))
                Fptr.setParam(1197, position.measurementUnit.toString(), Fptr.IGNORE_IF_EMPTY)
        }

        for (var i = 0; i < arr1260.length; i++) {
            Fptr.setParam(1260, arr1260[i], Fptr.IGNORE_IF_EMPTY);
        }

        Fptr.setParam(1229, position.exciseSum, Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(1230, position.countryCode, Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(1231, position.customsDeclaration, Fptr.IGNORE_IF_EMPTY);
        Fptr.setUserParam(3, position.ucUserParam3, Fptr.IGNORE_IF_EMPTY);
        Fptr.setUserParam(4, position.ucUserParam4, Fptr.IGNORE_IF_EMPTY);
        Fptr.setUserParam(5, position.ucUserParam5, Fptr.IGNORE_IF_EMPTY);
        Fptr.setUserParam(6, position.ucUserParam6, Fptr.IGNORE_IF_EMPTY);

        if (!validators.isMissing(position.additionalAttribute)) {
            if (validators.isMissing(position.additionalAttributePrint) || position.additionalAttributePrint) {
                Fptr.setParam(1191, position.additionalAttribute);
            }
            else {
                Fptr.setNonPrintableParam(1191, position.additionalAttribute);
            }
        }

        Fptr.setParam(Fptr.LIBFPTR_PARAM_COMMODITY_NAME, position.name, Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(Fptr.LIBFPTR_PARAM_PRICE, position.price);
        Fptr.setParam(Fptr.LIBFPTR_PARAM_QUANTITY, position.quantity);
        Fptr.setParam(Fptr.LIBFPTR_PARAM_POSITION_SUM, position.amount);
        Fptr.setParam(Fptr.LIBFPTR_PARAM_INFO_DISCOUNT_SUM, position.infoDiscountAmount, Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(Fptr.LIBFPTR_PARAM_DEPARTMENT, position.department, Fptr.IGNORE_IF_EMPTY);
        if (!validators.isMissing(position.tax)) {
            Fptr.setParam(Fptr.LIBFPTR_PARAM_TAX_TYPE, utils.parseTaxType(position.tax.type));
            Fptr.setParam(Fptr.LIBFPTR_PARAM_USE_ONLY_TAX_TYPE, validators.isMissing(position.tax.sum));
            if (!validators.isMissing(position.tax.sum)) {
                Fptr.setParam(Fptr.LIBFPTR_PARAM_TAX_SUM, position.tax.sum);
            }
        }
        Fptr.setParam(Fptr.LIBFPTR_PARAM_COMMODITY_PIECE, position.piece, Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(1214, utils.parsePaymentMethod(position.paymentMethod), Fptr.IGNORE_IF_EMPTY);
        Fptr.setParam(1212, utils.parsePaymentObject(position.paymentObject), Fptr.IGNORE_IF_EMPTY);

        if (!validators.isMissing(position.customParameters)) {
            for (var i = 0; position.customParameters && i < position.customParameters.length; i++) {
                Fptr.setUserParam(position.customParameters[i].id, position.customParameters[i].value)
            }
        }

        if (!validators.isMissing(position.positionForm)) {
            Fptr.setParam(Fptr.LIBFPTR_PARAM_REGISTRATION_POSITION_FORM, utils.REGISTRATION_POSITION_FORM[position.positionForm]);
        }
        // Подаём параметр LIBFPTR_PARAM_MODE, чтобы провести метод openReceipt виртуально
        Fptr.setParam(Fptr.LIBFPTR_PARAM_MODE, 1);
        if (Fptr.registration() < 0) {
            return Fptr.error();
        }  
    }

    if (!validators.isMissing(task.paymentsAddInfo)) {
        for (var i = 0; i < task.paymentsAddInfo.length; i++) {
            Fptr.setParam(Fptr.LIBFPTR_PARAM_PAYMENT_TYPE, Fptr.LIBFPTR_PT_ADD_INFO);
            Fptr.setParam(Fptr.LIBFPTR_PARAM_PAYMENT_SUM, task.paymentsAddInfo[i].sum);
            Fptr.setParam(Fptr.LIBFPTR_PARAM_ELECTRONICALLY_PAYMENT_METHOD, task.paymentsAddInfo[i].paymentMethod);
            Fptr.setParam(Fptr.LIBFPTR_PARAM_ELECTRONICALLY_ID, task.paymentsAddInfo[i].electronicallyId);
            Fptr.setParam(Fptr.LIBFPTR_PARAM_ELECTRONICALLY_ADD_INFO, task.paymentsAddInfo[i].electronicallyAddInfo, Fptr.IGNORE_IF_EMPTY);
            // Подаём параметр LIBFPTR_PARAM_MODE, чтобы провести метод payment виртуально
            Fptr.setParam(LIBFPTR_PARAM_MODE, 1);
            if (Fptr.payment() < 0) {
                return Fptr.error();
            } 
        }
    }
    
    return Fptr.ok({
            receiptSize: Fptr.getParamInt(Fptr.LIBFPTR_PARAM_RECEIPT_SIZE),
            receiptPercentageSize: Fptr.getParamInt(Fptr.LIBFPTR_PARAM_RECEIPT_PERCENTAGE_SIZE)
        });
};
