const utils = require('myscripts_utils');
const validators = require('myscripts_validators');

function validate(task) {
    validators.mustString(task.fileName, "fileName");
    validators.mustNumberOrMissing(task.scalePercent, "scalePercent");
}

function validateTask(task) {
    try {
        validate(task);
    } catch (e) {
        if (e.name === "InvalidJsonValueError") {
            return Fptr.result(Fptr.LIBFPTR_ERROR_RECEIPT_PARSE_ERROR, "Некорректное значение поля \"" + e.path + "\" (" + e.value + ")")
        } else if (e.name === "InvalidJsonTypeError") {
            return Fptr.result(Fptr.LIBFPTR_ERROR_RECEIPT_PARSE_ERROR, "Поле \"" + e.path + "\" имеет неверный тип (ожидается \"" + e.expectedType + "\")");
        } else if (e.name === "JsonValueNotFoundError") {
            return Fptr.result(Fptr.LIBFPTR_ERROR_RECEIPT_PARSE_ERROR, "Поле \"" + e.path + "\" отсутствует");
        } else {
            throw e;
        }
    }
    return Fptr.ok();
}

function execute(task) {
    v = validateTask(task);
    if (v.isError) {
        return v;
    }

    Fptr.setParam(Fptr.LIBFPTR_PARAM_FILENAME, task.fileName);
    Fptr.setParam(Fptr.LIBFPTR_PARAM_SCALE_PERCENT, task.scalePercent, Fptr.IGNORE_IF_EMPTY);
    if (Fptr.uploadPictureCliche() < 0) {
        return Fptr.error();
    }
    return Fptr.ok();
}
