function execute(task) {
    Fptr.setParam(Fptr.LIBFPTR_PARAM_DATA_TYPE, Fptr.LIBFPTR_DT_MCU_INFO)
    if (Fptr.queryData() < 0) {
        return Fptr.error();
    }
    var mcu = {};
    mcu.sn = Fptr.getParamString(Fptr.LIBFPTR_PARAM_MCU_SN);
    mcu.partId = Fptr.getParamString(Fptr.LIBFPTR_PARAM_MCU_PART_ID);
    mcu.partName = Fptr.getParamString(Fptr.LIBFPTR_PARAM_MCU_PART_NAME);
    var dataFlash = {};
    dataFlash.jedecId = Fptr.getParamInt(Fptr.LIBFPTR_PARAM_DATAFLASH_JEDEC_ID);
    dataFlash.name = Fptr.getParamString(Fptr.LIBFPTR_PARAM_DATAFLASH_NAME);
    dataFlash.size = Fptr.getParamInt(Fptr.LIBFPTR_PARAM_DATAFLASH_SIZE);
    var framEeprom = {};
    framEeprom.name = Fptr.getParamString(Fptr.LIBFPTR_PARAM_FRAM_EEPROM_NAME);
    framEeprom.size = Fptr.getParamInt(Fptr.LIBFPTR_PARAM_FRAM_EEPROM_SIZE);

    return Fptr.ok(
        { mcu, dataFlash, framEeprom }
    );
}

function validateTask(task) {
    return Fptr.ok();
}
